#
# Classifies a single text file specified as an input argument.
#
# Uses a classifier trained with the text_topic_classifier.py script.
#
# Example run 0: python single_classify.py -h
#
# Example run 1: python single_classify.py -input  test-248-only-body-papers/PMID-30597491.txt -clf classifiers/Bagging.pkl
#
# This software is released under the GNU General Public License (GPL) v3.
#
# Written by Kamran Karimi
#

import sys, joblib, argparse

parser = argparse.ArgumentParser()
parser.add_argument("-input", help = "File to be classified")
parser.add_argument("-clf", help = "The classifier to use, as a .pkl file")
args = parser.parse_args()

if args.input:
	f=open(args.input, 'r', encoding="utf8") 
else:
	print ("No input file to classify specified. Exiting.")
	sys.exit(-1)
if args.clf:
	clf = joblib.load(args.clf)
else:
	print ("No classifier specified. Exiting.")
	sys.exit(-1)

text = []
text.append(f.read())
predicted = clf.predict(text)
sys.exit(int(predicted[0]))